<?xml version="1.0" encoding="windows-1251" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

        <xsl:output method="text"  encoding="windows-1251"/>
        <xsl:strip-space elements="*"/>
        <xsl:decimal-format/>
        <xsl:template match="pack">
                <!-- -->
                <xsl:text>FK|TXTS170417|</xsl:text>
                <xsl:value-of select="@progname"/>
                <xsl:text>|</xsl:text>
                <!---->
                <xsl:value-of select="substring(@progver,1,10)"/>
                <xsl:text>||</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>FROM|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/BUDG_LEVEL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/KOD_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>TO|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/NAME_TOFK"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <xsl:apply-templates select="TS"/>
        </xsl:template>
        <xsl:template match="TS">
                <xsl:text>TS|</xsl:text>
                <xsl:text>|</xsl:text><!--GUID_FK-->
                <xsl:value-of select="TYPE"/><xsl:text>|</xsl:text>
                <xsl:text>1|</xsl:text><!-- -->
                <xsl:value-of select="GOD_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/LS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/OKPO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/INN"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/KPP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_PREVIOUS"/>|<xsl:value-of select="NAME_BUD"/>|<xsl:value-of select="OKATO"/><!--OKTMO--><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_UCHR"/><xsl:text>|</xsl:text>
                <xsl:text>|</xsl:text><!--LS_ORG-->
                <xsl:value-of select="GLAVA_UCHR"/><xsl:text>|</xsl:text>
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--NAME_Z-->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--  -->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--CODE_CS-->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--NPA-->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--NUM_NPA-->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--DATE_NPA-->
				<xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--ID_CODE_GK-->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--CODE_COOP-->
				<xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--NOM_GK-->
				<xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--DATE_GK-->
                <xsl:value-of select="KLIENT/NAME_TOFK"/>|<xsl:value-of select="KLIENT/OKPO_TOFK"/>|<xsl:value-of select="KLIENT/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_RUK"/>|<xsl:value-of select="NAME_RUK_FES"/><xsl:text>|</xsl:text>
				<xsl:value-of select="DOL_ISP"/>|<xsl:value-of select="FIO_ISP"/>|<xsl:value-of select="TEL_ISP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_POD"/><xsl:text>|</xsl:text>
                <xsl:value-of select="SUM_OST"/><xsl:text>|</xsl:text>
                <xsl:if test="not(sum(TSSUBS/SUM_PERMIT_OST)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PERMIT_OST),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
				<!--SUM_DZ--><xsl:text>|</xsl:text><!-- "TYPE" - 1  2  .-->
				<!--SUM_IT_DZ_ISP--><xsl:if test="not(sum(TSSUBS/SUM_DZ)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_DZ),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(sum(TSSUBS/SUM_PLAN_POST)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PLAN_POST),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(sum(TSSUBS/SUM_PLAN_VIP)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PLAN_VIP),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:value-of select="ORG_SIG"/>|<xsl:value-of select="DOL_SIG"/>|<xsl:value-of select="FIO_SIG"/>|<xsl:value-of select="DATE_SIG"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!--
				<xsl:text>TSCM||||||</xsl:text><xsl:text>&#13;&#10;</xsl:text>
				-->
                <xsl:apply-templates select="TSSUBS"/>
        </xsl:template>
        <xsl:template match="TSSUBS">
                <xsl:text>TSSUBS|</xsl:text><xsl:value-of select="NAME_SUBS"/>|<xsl:value-of select="CODE_SUBS"/><xsl:text>|</xsl:text>
				<xsl:value-of select="KBK_R"/>|<xsl:value-of select="FAIP_CODE"/><xsl:text>|</xsl:text><xsl:value-of select="ADD_KLASS"/><xsl:text>|</xsl:text>
                <!--SUM_OST_CS--><xsl:text>|</xsl:text><!-- "TYPE" - 1  2  .-->
                <xsl:if test="not(SUM_PERMIT_OST=0)"><xsl:value-of select="format-number(SUM_PERMIT_OST,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:value-of select="KOD_SUM_DZ"/><xsl:text>|</xsl:text>
				<!--SUM_DZ--><xsl:text>|</xsl:text><!-- "TYPE" - 1  2  .-->
                <!--SUM_DZ_ISP--><xsl:if test="not(SUM_DZ=0)"><xsl:value-of select="format-number(SUM_DZ,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
				<xsl:if test="not(SUM_PLAN_POST=0)"><xsl:value-of select="format-number(SUM_PLAN_POST,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM_PLAN_VIP=0)"><xsl:value-of select="format-number(SUM_PLAN_VIP,'0.00')"/></xsl:if><xsl:text>|</xsl:text>            
                <xsl:text>&#13;&#10;</xsl:text>
        </xsl:template>

</xsl:stylesheet>


