<?xml version="1.0" encoding="windows-1251"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" encoding="windows-1251" indent="yes" />
	<xsl:strip-space elements="*"/>
	<xsl:variable name="accept"> !"#$%'()*+,-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{}~</xsl:variable>
	<!--    -->
	<xsl:template name="CheckSym">
		<xsl:param name="sym"/>
		<xsl:param name="count"/>
		<xsl:param name="name"/>
		<xsl:if test="not(contains($accept,substring($sym,$count,1)))">
			<xsl:element name="error">
				<xsl:attribute name="must">1</xsl:attribute>
				<xsl:text/> "<xsl:value-of select="$name"/>"   "<xsl:value-of select="substring($sym,$count,1)"/>"   <xsl:value-of select="$count"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="$count &lt; string-length($sym)">
			<xsl:call-template name="CheckSym">
				<xsl:with-param name="sym" select="$sym"/>
				<xsl:with-param name="name" select="$name"/>
				<xsl:with-param name="count" select="$count+1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="CheckS">
		<xsl:param name="value"/>
		<xsl:param name="name"/>
		<xsl:param name="must"/>
		<xsl:param name="length"/>
		<xsl:variable name="labs">
			<xsl:choose>
				<xsl:when test="$length &gt; 0">
					<xsl:value-of select="$length"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="-1*$length"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="string-length($value)=0 and not($must=-1) ">
			<xsl:element name="error">
				<xsl:attribute name="must">
					<xsl:value-of select="$must"/>
				</xsl:attribute>
				<xsl:choose>
					<xsl:when test="$must=1">  </xsl:when>
					<xsl:otherwise> </xsl:otherwise>
				</xsl:choose>
				<xsl:text/>"<xsl:value-of select="$name"/>"  .</xsl:element>
		</xsl:if>
		<xsl:if test="string-length($value)&gt;0">
			<xsl:call-template name="CheckSym">
				<xsl:with-param name="sym" select="$value"/>
				<xsl:with-param name="name" select="$name"/>
				<xsl:with-param name="count" select="1"/>
			</xsl:call-template>
			<xsl:if test="string-length($value) &gt; $labs">
				<xsl:element name="error">
					<xsl:attribute name="must">1</xsl:attribute>
					<xsl:text/> "<xsl:value-of select="$name"/>"    (<xsl:value-of select="$labs"/>)</xsl:element>
			</xsl:if>
			<xsl:if test="(string-length($value) &lt; $length) and ($length &gt; 0)">
				<xsl:element name="error">
					<xsl:attribute name="must">1</xsl:attribute>
					<xsl:text/> "<xsl:value-of select="$name"/>"    (<xsl:value-of select="$length"/>)</xsl:element>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!--     -->
	<xsl:template name="validate" match="PP">
		<xsl:element name="errors">
			<xsl:if test="UCH_TB=0">
				<xsl:element name="error">
					<xsl:attribute name="must">1</xsl:attribute>
					 ''     </xsl:element>
			</xsl:if>
			<!--    :
			2    Ի;
			3   ;
			6   ˻.-->
			<xsl:if test="not(PAY/BUDG_LEVEL='2' or PAY/BUDG_LEVEL='3' or PAY/BUDG_LEVEL='6') ">
				<xsl:element name="error">
				<xsl:attribute name="must">1</xsl:attribute> " "     "2", "4"  "6" ( "<xsl:value-of select="PAY/codebudg"/>")</xsl:element>
			</xsl:if>
			
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">5</xsl:with-param>
				<xsl:with-param name="value" select="PAY/KOD_UBP"/>
				<!--    BUDG_LEVEL = 6,      ,  .     BUDG_LEVEL    . -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-2000</xsl:with-param>
				<xsl:with-param name="value" select="PAY/NAME_UBP"/>
				<!--   .    BUDG_LEVEL  =  6,      ,  .     BUDG_LEVEL      . -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">4</xsl:with-param>
				<xsl:with-param name="value" select="PAY/KOD_TOFK"/>
				<!--       . -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">   </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-2000</xsl:with-param>
				<xsl:with-param name="value" select="PAY/NAME_TOFK"/>
				<!--   .       . -->
			</xsl:call-template>
			<xsl:if test="round(SUM*100)=0">
				<xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>    </xsl:element>
			</xsl:if>
			<xsl:if test="DATE=''">
				<xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>    </xsl:element>
			</xsl:if>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-10</xsl:with-param>
				<xsl:with-param name="value" select="NOM"/>
			</xsl:call-template>
			<xsl:if test="not(VID_OPER='01')">
				<xsl:element name="error">
					<xsl:attribute name="must">1</xsl:attribute>
					    "01" ( "<xsl:value-of select="VID_OPER"/>")</xsl:element>
				<!-- ( 18)*.   : 01. -->	
			</xsl:if>
			<xsl:if test="not(VID_PL='0' or VID_PL='4')">
				<xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>   : ''(0)  ''(4)</xsl:element>
			</xsl:if>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-12</xsl:with-param>
				<xsl:with-param name="value" select="PAY/INN"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-9</xsl:with-param>
				<xsl:with-param name="value" select="PAY/KPP"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  -   </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-160</xsl:with-param>
				<xsl:with-param name="value" select="PAY/CNAME"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">    </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">20</xsl:with-param>
				<xsl:with-param name="value" select="PAY/BS"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">9</xsl:with-param>
				<xsl:with-param name="value" select="PAY/BIC"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-255</xsl:with-param>
				<xsl:with-param name="value" select="PAY/NAME_BIC"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">-255</xsl:with-param>
				<xsl:with-param name="value" select="PAY/CITY_BIC"/>
			</xsl:call-template>
			<xsl:if test="string-length(concat(PAY/CITY_BIC,PAY/NAME_BIC)) &gt; 160">
				<xsl:element name="error">
					<xsl:attribute name="must">1</xsl:attribute> "  "   (160)</xsl:element>
			</xsl:if>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">    </xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">20</xsl:with-param>
				<xsl:with-param name="value" select="PAY/BS_KS"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">0</xsl:with-param>
				<xsl:with-param name="length">-12</xsl:with-param>
				<xsl:with-param name="value" select="RCP/INN"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">0</xsl:with-param>
				<xsl:with-param name="length">-9</xsl:with-param>
				<xsl:with-param name="value" select="RCP/KPP"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  -   </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-160</xsl:with-param>
				<xsl:with-param name="value" select="RCP/CNAME"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">0</xsl:with-param>
				<xsl:with-param name="length">20</xsl:with-param>
				<xsl:with-param name="value" select="RCP/BS"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">9</xsl:with-param>
				<xsl:with-param name="value" select="RCP/BIC"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">-255</xsl:with-param>
				<xsl:with-param name="value" select="RCP/CITY_BIC"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-255</xsl:with-param>
				<xsl:with-param name="value" select="RCP/NAME_BIC"/>
			</xsl:call-template>
			<xsl:if test="string-length(concat(RCP/CITY_BIC,RCP/NAME_BIC)) &gt; 160">
				<xsl:element name="error">
					<xsl:attribute name="must">1</xsl:attribute> "  "   (160)</xsl:element>
			</xsl:if>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">    </xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">20</xsl:with-param>
				<xsl:with-param name="value" select="RCP/BS_KS"/>
			</xsl:call-template>
			<xsl:variable name="ORDER_PAY0">
				<xsl:choose>
					<xsl:when test="starts-with(ORDER_PAY,'0')">
						<xsl:value-of select="substring(ORDER_PAY,2,255)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="ORDER_PAY"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">1</xsl:with-param>
				<xsl:with-param name="value" select="$ORDER_PAY0"/>
				<!-- ( 21)*.       0  6 (0    ).  -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name"> </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">-210</xsl:with-param>
				<xsl:with-param name="value" select="PURPOSE"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">2</xsl:with-param>
				<xsl:with-param name="value" select="PAYSTATUS"/>
			</xsl:call-template>
			<xsl:variable name="stat_must">
				<xsl:choose>
					<xsl:when test="PAYSTATUS=''">-1</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">20</xsl:with-param>
				<xsl:with-param name="value" select="KBK"/>
				<!-- ( 104)*.   ,    PAYSTATUS. -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  (105)</xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">-11</xsl:with-param>
				<xsl:with-param name="value" select="OKATO"/>
				<!-- ( 105)*.   ,    PAYSTATUS. -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">   (106)</xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">-2</xsl:with-param>
				<xsl:with-param name="value" select="OSNPLAT"/>
				<!-- ( 106)*.   ,    PAYSTATUS -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">   (107)</xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">-10</xsl:with-param>
				<xsl:with-param name="value" select="NAL_PER"/>
				<!-- ( 107)*.   ,    PAYSTATUS. -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">   (108)</xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">-15</xsl:with-param>
				<xsl:with-param name="value" select="NUM_DOK"/>
				<!-- ( 108)*.   ,    PAYSTATUS. -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">   (109)</xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">-10</xsl:with-param>
				<xsl:with-param name="value" select="DATE_DOK"/>
				<!-- ( 109)*.   ,    PAYSTATUS. -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  (110)</xsl:with-param>
				<xsl:with-param name="must">
					<xsl:value-of select="$stat_must"/>
				</xsl:with-param>
				<xsl:with-param name="length">-2</xsl:with-param>
				<xsl:with-param name="value" select="TYPE_PL"/>
				<!-- ( 110)*.   ,    PAYSTATUS. -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  ()</xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">-25</xsl:with-param>
				<xsl:with-param name="value" select="UIN"/>
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">1</xsl:with-param>
				<xsl:with-param name="length">11</xsl:with-param>
				<xsl:with-param name="value" select="PAY/LS"/>
				<!-- / , , .          ,       , /    . -->
			</xsl:call-template>
			<xsl:call-template name="CheckS">
				<xsl:with-param name="name">  </xsl:with-param>
				<xsl:with-param name="must">-1</xsl:with-param>
				<xsl:with-param name="length">11</xsl:with-param>
				<xsl:with-param name="value" select="RCP/LS"/>
				<!--             -  -  / -,     .	 -->
			</xsl:call-template>
			<xsl:for-each select="PPST">
				<xsl:call-template name="CheckS">
					<xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
					<xsl:with-param name="must">0</xsl:with-param>
					<xsl:with-param name="length">20</xsl:with-param>
					<xsl:with-param name="value" select="KBK"/>
				</xsl:call-template>
				<xsl:call-template name="CheckS">
					<xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
					<xsl:with-param name="must">-1</xsl:with-param>
					<xsl:with-param name="length">20</xsl:with-param>
					<xsl:with-param name="value" select="ADD_KLASS"/>
				</xsl:call-template>
				<xsl:call-template name="CheckS">
					<xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
					<xsl:with-param name="must">-1</xsl:with-param>
					<xsl:with-param name="length">20</xsl:with-param>
					<xsl:with-param name="value" select="ADD_KLASS_RCP"/>
				</xsl:call-template>
				<xsl:call-template name="CheckS">
					<xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
					<xsl:with-param name="must">-1</xsl:with-param>
					<xsl:with-param name="length">2</xsl:with-param>
					<xsl:with-param name="value" select="MES_FIN"/>
				</xsl:call-template>
				<xsl:call-template name="CheckS">
					<xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
					<xsl:with-param name="must">-1</xsl:with-param>
					<xsl:with-param name="length">-40</xsl:with-param>
					<xsl:with-param name="value" select="REZERV"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
