<?xml version="1.0" encoding="windows-1251" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

        <xsl:output method="text"  encoding="windows-1251"/>
        <xsl:strip-space elements="*"/>
        <xsl:decimal-format/>
        <xsl:template match="pack">
                <!-- -->
                <xsl:text>FK|TXTS180903|</xsl:text>
                <xsl:value-of select="@progname"/>
                <xsl:text>|</xsl:text>
                <!---->
                <xsl:value-of select="substring(@progver,1,10)"/>
                <xsl:text>||</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>FROM|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/BUDG_LEVEL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/KOD_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>TO|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TS[1]/KLIENT/NAME_TOFK"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <xsl:apply-templates select="TS"/>
        </xsl:template>
        <xsl:template match="TS">
                <xsl:text>TS|</xsl:text>
                <xsl:text>|</xsl:text><!--GUID_FK-->
                <xsl:value-of select="TYPE"/><xsl:text>|</xsl:text>
                <xsl:text>1|</xsl:text><!--   "2"         .-->
                <xsl:value-of select="GOD_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/KOD_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/LS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/INN"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KLIENT/KPP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_PREVIOUS"/><xsl:text>|</xsl:text>
                <xsl:text>|</xsl:text><!--NAME_SUB-->
                <xsl:text>|</xsl:text><!--LS_SUB-->
                <xsl:text>|</xsl:text><!--KPP_SUB-->
                <xsl:text>|</xsl:text><!--CODE_UBP_SUB-->

                <xsl:value-of select="NAME_BUD"/>|<xsl:value-of select="OKATO"/><!--OKTMO--><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_UCHR"/><xsl:text>|</xsl:text>
                <xsl:text>|</xsl:text><!--LS_Z-->
                <xsl:value-of select="GLAVA_UCHR"/><xsl:text>|</xsl:text>
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--CODE_UBP_Z-->
                <xsl:if test="TYPE=3"><xsl:text></xsl:text></xsl:if><xsl:text>|</xsl:text><!--NAME_Z-->
                <xsl:value-of select="KLIENT/NAME_TOFK"/>|<xsl:value-of select="KLIENT/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_RUK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DOL_RUK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_RUK_FES"/><xsl:text>|</xsl:text>
				<xsl:value-of select="DOL_ISP"/>|<xsl:value-of select="FIO_ISP"/>|<xsl:value-of select="TEL_ISP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_POD"/><xsl:text>|</xsl:text>
                <xsl:if test="not(sum(TSSUBS/SUM_PERMIT_OST)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PERMIT_OST),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
				<!--SUM_IT_DZ_ISP--><xsl:if test="not(sum(TSSUBS/SUM_DZ)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_DZ),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(sum(TSSUBS/SUM_PLAN_POST)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PLAN_POST),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(sum(TSSUBS/SUM_PLAN_POST)+sum(TSSUBS/SUM_DZ)+sum(TSSUBS/SUM_PERMIT_OST)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PLAN_POST)+sum(TSSUBS/SUM_DZ)+sum(TSSUBS/SUM_PERMIT_OST),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                
                <xsl:if test="not(sum(TSSUBS/SUM_PLAN_VIP)=0)"><xsl:value-of select="format-number(sum(TSSUBS/SUM_PLAN_VIP),'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:value-of select="ORG_SIG"/>|<xsl:value-of select="DOL_SIG"/>|<xsl:value-of select="FIO_SIG"/>|<xsl:value-of select="DATE_SIG"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!--
				<xsl:text>TSCM||||||</xsl:text><xsl:text>&#13;&#10;</xsl:text>
				-->
                <xsl:apply-templates select="TSSUBS" mode="rows"/>
                <!--    -->
                <xsl:apply-templates select="TSSUBS" mode="tots"/>
        </xsl:template>
        <xsl:template match="TSSUBS" mode="rows">
                <xsl:text>TSSUBS|</xsl:text>
                <xsl:value-of select="NAME_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="CODE_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NOM_GK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_GK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="ID_CODE_GK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="FAIP_CODE"/><xsl:text>|</xsl:text>
                <xsl:value-of select="ADD_KLASS_PAY"/><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM_PERMIT_OST=0)"><xsl:value-of select="format-number(SUM_PERMIT_OST,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM_DZ=0)"><xsl:value-of select="format-number(SUM_DZ,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM_PLAN_POST=0)"><xsl:value-of select="format-number(SUM_PLAN_POST,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM_PLAN_POST+SUM_DZ+SUM_PERMIT_OST=0)"><xsl:value-of select="format-number(SUM_PLAN_POST+SUM_DZ+SUM_PERMIT_OST,'0.00')"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM_PLAN_VIP=0)"><xsl:value-of select="format-number(SUM_PLAN_VIP,'0.00')"/></xsl:if><xsl:text>|</xsl:text>            
                <xsl:text>&#13;&#10;</xsl:text>
        </xsl:template>
        <xsl:template match="TSSUBS" mode="tots">
        		<xsl:variable name="key" select="../TSSUBS[CODE_SUBS=current()/CODE_SUBS]"></xsl:variable>
                <xsl:if test=".=$key[1]">
                <xsl:text>TSISUBS|</xsl:text>
                <xsl:value-of select="CODE_SUBS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="format-number(sum($key/SUM_PERMIT_OST),'0.00')"/><xsl:text>|</xsl:text>
                <xsl:value-of select="format-number(sum($key/SUM_DZ),'0.00')"/><xsl:text>|</xsl:text>
                <xsl:value-of select="format-number(sum($key/SUM_PLAN_POST),'0.00')"/><xsl:text>|</xsl:text>
                <xsl:value-of select="format-number(sum($key/SUM_PLAN_POST)+sum($key/SUM_DZ)+sum($key/SUM_PERMIT_OST),'0.00')"/><xsl:text>|</xsl:text>
                <xsl:value-of select="format-number(sum($key/SUM_PLAN_VIP),'0.00')"/><xsl:text>|</xsl:text>            
                <xsl:text>&#13;&#10;</xsl:text>
                </xsl:if>
        </xsl:template>

</xsl:stylesheet>


