<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" encoding="windows-1251" />
	<xsl:template match="PPST">
		<xsl:variable name="key" select="../PPST[KOD_FIN=current()/KOD_FIN][TYPE_KBK=current()/TYPE_KBK][KBK=current()/KBK]"></xsl:variable>
		<xsl:if test=".=$key[1]">
		<xsl:element name="PPST">
			<xsl:copy-of select="child::*[not(name()='SUM')]"></xsl:copy-of>
			<xsl:element name="SUM">
				<xsl:value-of select="format-number(sum($key/SUM),'0.00')"></xsl:value-of>
			</xsl:element>
		</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- standard copy template -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>	
</xsl:stylesheet>