# -*- coding: windows-1251 -*-
'''
Created on 17 03 2017 .

@author: scond
'''
import logging
import re
pattern = re.compile('\A[ ]*[-_A-Z-a-z0-9]+\Z')


def line_is_ok(line):
    ls = line.strip()
    if not ls:
        return False
    if ls in ('(', ')', ']'):
        return True
    if ls[0] == '[':
        return True
    if '=' in ls.split(' ')[0] and pattern.match(ls.split('=')[0]):
        return True
    return False

def ex_split(lines):
    for line in lines:
        for subline in line.split('\r'):
            yield subline
    
def process_lines(lines, merge_sym=' '):
    l = ''
    for i, line in enumerate(ex_split(lines)):
        if line_is_ok(line):
            if l.strip("\r\n"):
                yield l.strip("\r\n") + "\n"
            l = line
        else:
            logging.debug('Broken line ' + str(i) + ' :"' +
                          line.strip("\r\n") + '"')
            l = l.strip("\r\n") + merge_sym + line.strip("\r\n") + "\n"
    yield l


def process_files(src, dst, log=None, merge_sym=' '):
    '''
       -    

    src -    ''
    dst -    '' (     )
    log - ,       
    '''
    if log is not None:
        logging.basicConfig(filename=log,
                            level=logging.DEBUG)
    src = open(src, 'r')
    dst = open(dst, 'wb')
    dst.writelines(process_lines(src, merge_sym))
    dst.close()
    src.close()


if __name__ == '__main__':
    import argparse
    p = argparse.ArgumentParser(description="Fix crd with newlines")
    p.add_argument('src', type=argparse.FileType('r'),
                   help='Source file')
    p.add_argument('dst', type=argparse.FileType('w'),
                   help='Result file')
    p.add_argument('--symbol', help='Merge lines with this symbol (default: "%(default)s")', default=' ')
    args = p.parse_args()
    merge_symbol = args.symbol
    if merge_symbol.startswith('"') and merge_symbol.endswith('"'):
        merge_symbol = merge_symbol[1:-1]
    logging.Logger.setLevel(logging.getLogger(), logging.DEBUG)
    logging.debug("Merge symbol: '" + merge_symbol + "'")
    args.dst.writelines(process_lines(args.src, merge_symbol))
    args.dst.close()
