<?xml version="1.0" encoding="windows-1251" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="text"  encoding="windows-1251"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="pack">
		<!-- -->
		<xsl:text>FK|TXUK180101|</xsl:text>
		<xsl:value-of select="@progname"/>
		<xsl:text>|</xsl:text>
		<!---->
		<xsl:value-of select="substring(@progver,1,10)"/>
		<xsl:text>||</xsl:text>
		<xsl:text>&#13;&#10;</xsl:text>
		<!-- -->
		<xsl:text>FROM|</xsl:text>
		<xsl:value-of select="UK[1]/NUBP/KOD_UBP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="UK[1]/NUBP/NAME_UBP"/><xsl:text>|</xsl:text>
		<xsl:text>&#13;&#10;</xsl:text>
		<!-- -->
		<xsl:text>TO|</xsl:text>
		<xsl:value-of select="UK[1]/NUBP/KOD_TOFK"/><xsl:text>|</xsl:text>
		<xsl:value-of select="UK[1]/NUBP/NAME_TOFK"/><xsl:text>|</xsl:text>
		<xsl:text>&#13;&#10;</xsl:text>
		<xsl:apply-templates select="UK"/>
		
	</xsl:template>
	
	<xsl:template match="UK">
		<xsl:text>UK||</xsl:text>
		<xsl:value-of select="NOM_UK"/><xsl:text>|</xsl:text>
		<xsl:value-of select="DATE_UK"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NUBP/KOD_TOFK"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NUBP/NAME_TOFK"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NUBP/KOD_UBP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NUBP/NAME_UBP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NUBP/OKPO"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NUBP/LS"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NAME_RUK"/><xsl:text>|</xsl:text>
		<xsl:value-of select="DOL_ISP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NAME_ISP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="TEL_ISP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="DATE_POD"/><xsl:text>|</xsl:text>
		<xsl:text>|</xsl:text>
		<xsl:text>|</xsl:text>
		<xsl:text>&#13;&#10;</xsl:text>
	
		<xsl:apply-templates select="UKPP"/>
		<xsl:apply-templates select="UKPP_N"/>
	</xsl:template>
	<xsl:template match="UKPP">
		<xsl:text>UKPP|</xsl:text>
		<xsl:value-of select="LINE_NOM"/><xsl:text>|</xsl:text>
		<xsl:value-of select="GUID"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NAME_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NOM_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="DATE_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="CNAME_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="INN_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="KPP_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="KBK"/><xsl:text>|</xsl:text>
		<xsl:text>|</xsl:text><!--   -->
		<xsl:value-of select="ADD_KLASS"/><xsl:text>|</xsl:text>
		<xsl:value-of select="SUM_PP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="PURPOSE"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NOTE"/><xsl:text>|</xsl:text>
		<xsl:text>&#13;&#10;</xsl:text>
	
	</xsl:template>
	<xsl:template match="UKPP_N">
		<xsl:text>UKPP_N|</xsl:text>
		<xsl:value-of select="LINE_NOM"/><xsl:text>|</xsl:text>
		<xsl:value-of select="CNAME_NUBP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="INN_NUBP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="KPP_NUBP"/><xsl:text>|</xsl:text>
		<xsl:value-of select="KBK"/><xsl:text>|</xsl:text>
		<xsl:text>|</xsl:text><!--   -->
		<xsl:value-of select="ADD_KLASS"/><xsl:text>|</xsl:text>
		<xsl:if test="not(SUM=0)"><xsl:value-of select="SUM"/></xsl:if><xsl:text>|</xsl:text>
		<xsl:value-of select="PURPOSE"/><xsl:text>|</xsl:text>
		<xsl:value-of select="NOTE"/><xsl:text>|</xsl:text>
		<xsl:text>&#13;&#10;</xsl:text>
	
	</xsl:template>
</xsl:stylesheet>


