<?xml version="1.0" encoding="windows-1251"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
        <xsl:output method="xml" encoding="windows-1251" indent="yes"/>
        <xsl:strip-space elements="*"/>
        <xsl:variable name="accept"> !"#$%'()*+,-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{}~</xsl:variable>
        <xsl:template name="CheckSym">
                <xsl:param name="sym"/>
                <xsl:param name="count"/>
                <xsl:param name="name"/>
                <xsl:if test="not(contains($accept,substring($sym,$count,1)))">
                        <xsl:element name="error">
                                <xsl:attribute name="must">1</xsl:attribute>
                                <xsl:text/> "<xsl:value-of select="$name"/>"   "<xsl:value-of select="substring($sym,$count,1)"/>"   <xsl:value-of select="$count"/>
                        </xsl:element>
                </xsl:if>
                <xsl:if test="$count &lt; string-length($sym)">
                        <xsl:call-template name="CheckSym">
                                <xsl:with-param name="sym" select="$sym"/>
                                <xsl:with-param name="name" select="$name"/>
                                <xsl:with-param name="count" select="$count+1"/>
                        </xsl:call-template>
                </xsl:if>
        </xsl:template>
        <xsl:template name="CheckS">
                <xsl:param name="value"/>
                <xsl:param name="name"/>
                <xsl:param name="must"/>
                <xsl:param name="length"/>
                <xsl:variable name="labs">
                        <xsl:choose>
                                <xsl:when test="$length &gt; 0">
                                        <xsl:value-of select="$length"/>
                                </xsl:when>
                                <xsl:otherwise>
                                        <xsl:value-of select="-1*$length"/>
                                </xsl:otherwise>
                        </xsl:choose>
                </xsl:variable>
                <xsl:if test="string-length($value)=0 and not($must=-1) ">
                        <xsl:element name="error">
                                <xsl:attribute name="must">
                                        <xsl:value-of select="$must"/>
                                </xsl:attribute>
                                <xsl:choose>
                                        <xsl:when test="$must=1">  </xsl:when>
                                        <xsl:otherwise> </xsl:otherwise>
                                </xsl:choose>
                                <xsl:text/>"<xsl:value-of select="$name"/>"  .</xsl:element>
                </xsl:if>
                <xsl:if test="string-length($value)&gt;0">
                        <xsl:call-template name="CheckSym">
                                <xsl:with-param name="sym" select="$value"/>
                                <xsl:with-param name="name" select="$name"/>
                                <xsl:with-param name="count" select="1"/>
                        </xsl:call-template>
                        <xsl:if test="string-length($value) &gt; $labs">
                                <xsl:element name="error">
                                        <xsl:attribute name="must">1</xsl:attribute>
                                        <xsl:text/> "<xsl:value-of select="$name"/>"    (<xsl:value-of select="$labs"/>)</xsl:element>
                        </xsl:if>
                        <xsl:if test="(string-length($value) &lt; $length) and ($length &gt; 0)">
                                <xsl:element name="error">
                                        <xsl:attribute name="must">1</xsl:attribute>
                                        <xsl:text/> "<xsl:value-of select="$name"/>"    (<xsl:value-of select="$length"/>)</xsl:element>
                        </xsl:if>
                </xsl:if>
        </xsl:template>
        <xsl:template name="validate" match="UF">
                <xsl:element name="errors">
                        <xsl:if test="UCH_TB=0">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute> ''    </xsl:element>
                        </xsl:if>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">8</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/KOD_UBP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">1</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/BUDG_LEVEL"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_UBP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/NAME_UBP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">4</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/KOD_TOFK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/NAME_TOFK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-15</xsl:with-param>
                                <xsl:with-param name="value" select="NOM_UK"/>
                        </xsl:call-template>
                        <xsl:if test="DATE_UK=''">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>   </xsl:element>
                        </xsl:if>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">11</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/LS"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_GRS"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">3</xsl:with-param>
                                <xsl:with-param name="value" select="GLAVA_GRS"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-512</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/NAME_BUDG"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/NAME_UBP_FO"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">    </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">8</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/OKPO_FO"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">-1</xsl:with-param>
                                <xsl:with-param name="length">11</xsl:with-param>
                                <xsl:with-param name="value" select="NUBP/LS_FO"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">1</xsl:with-param>
                                <xsl:with-param name="value" select="FUND_SOURCE"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                        <!--       ,    .-->
                                <xsl:with-param name="must">-1</xsl:with-param>
                                <xsl:with-param name="length">-15</xsl:with-param>
                                <xsl:with-param name="value" select="NOM_ZF"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-160</xsl:with-param>
                                <xsl:with-param name="value" select="CNAME_PL"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-12</xsl:with-param>
                                <xsl:with-param name="value" select="INN_PL"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-9</xsl:with-param>
                                <xsl:with-param name="value" select="KPP_PL"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">-1</xsl:with-param>
                                <xsl:with-param name="length">-1000</xsl:with-param>
                                <xsl:with-param name="value" select="PASP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">20</xsl:with-param>
                                <xsl:with-param name="value" select="BS_PL"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-100</xsl:with-param>
                                <xsl:with-param name="value" select="DOL_RUK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS">
                                <xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_RUK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS">
                                <xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-100</xsl:with-param>
                                <xsl:with-param name="value" select="DOL_ISP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS">
                                <xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_ISP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS">
                                <xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">-1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="TEL_ISP"/>
                        </xsl:call-template>
                        <!--<xsl:if test="DATE_POD=''">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>    </xsl:element>
                        </xsl:if>-->
                        <xsl:apply-templates select="UKPP"/>
                        <xsl:apply-templates select="UKPP_N"/>
                </xsl:element>
        </xsl:template>
        <xsl:template match="UKPP">
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">0</xsl:with-param>
                        <xsl:with-param name="length">-160</xsl:with-param>
                        <xsl:with-param name="value" select="NAME_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-20</xsl:with-param>
                        <xsl:with-param name="value" select="NOM_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">    ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">0</xsl:with-param>
                        <xsl:with-param name="length">2</xsl:with-param>
                        <xsl:with-param name="value" select="KOD_DOC"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">GUID   ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">36</xsl:with-param>
                        <xsl:with-param name="value" select="GUID"/>
                </xsl:call-template>
                <xsl:if test="DATE_PP=''">
                        <xsl:element name="error"><xsl:attribute name="must">-1</xsl:attribute>     ( <xsl:value-of select="position()"/>)</xsl:element>
                </xsl:if>
                <xsl:call-template name="CheckS"><xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-500</xsl:with-param>
                        <xsl:with-param name="value" select="CNAME_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-12</xsl:with-param>
                        <xsl:with-param name="value" select="INN_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-9</xsl:with-param>
                        <xsl:with-param name="value" select="KPP_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">8</xsl:with-param>
                        <xsl:with-param name="value" select="OKATO"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">   ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">20</xsl:with-param>
                        <xsl:with-param name="value" select="KBK"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-20</xsl:with-param>
                        <xsl:with-param name="value" select="ADD_KLASS"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-500</xsl:with-param>
                        <xsl:with-param name="value" select="PURPOSE"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name"> ( <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-254</xsl:with-param>
                        <xsl:with-param name="value" select="NOTE"/>
                </xsl:call-template>
            </xsl:template>
            <xsl:template match="UKPP_N">
                <xsl:call-template name="CheckS"><xsl:with-param name="name">  (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-160</xsl:with-param>
                        <xsl:with-param name="value" select="CNAME_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS"><xsl:with-param name="name">  (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-12</xsl:with-param>
                        <xsl:with-param name="value" select="INN_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS"><xsl:with-param name="name">  (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-9</xsl:with-param>
                        <xsl:with-param name="value" select="KPP_PP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS"><xsl:with-param name="name">   (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">8</xsl:with-param>
                        <xsl:with-param name="value" select="OKATO"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS"><xsl:with-param name="name">   (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">11</xsl:with-param>
                        <xsl:with-param name="value" select="LS_UBP"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS"><xsl:with-param name="name">   (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">20</xsl:with-param>
                        <xsl:with-param name="value" select="KBK"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-20</xsl:with-param>
                        <xsl:with-param name="value" select="ADD_KLASS"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">-210</xsl:with-param>
                        <xsl:with-param name="value" select="PURPOSE"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  (  <xsl:value-of select="position()"/>)</xsl:with-param>
                        <xsl:with-param name="must">-1</xsl:with-param>
                        <xsl:with-param name="length">1</xsl:with-param>
                        <xsl:with-param name="value" select="FUND_SOURCE"/>
                </xsl:call-template>
            </xsl:template>
</xsl:stylesheet>
