<?xml version="1.0" encoding="windows-1251" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

        <xsl:output method="text"  encoding="windows-1251"/>
        <xsl:strip-space elements="*"/>

        <xsl:template match="pack">
                <!-- -->
                <xsl:text>FK|TXUF180101|</xsl:text>
                <xsl:value-of select="@progname"/>
                <xsl:text>|</xsl:text>
                <!---->
                <xsl:value-of select="substring(@progver,1,10)"/>
                <xsl:text>||</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>FROM|</xsl:text>
                <xsl:value-of select="UF[1]/NUBP/BUDG_LEVEL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="UF[1]/NUBP/KOD_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="UF[1]/NUBP/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>TO|</xsl:text>
                <xsl:value-of select="UF[1]/NUBP/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="UF[1]/NUBP/NAME_TOFK"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:if test="SECURE">
                    <xsl:text>SECURE|</xsl:text>
                    <xsl:value-of select="SECURE[1]/LEVEL"/><xsl:text>|</xsl:text>
                    <xsl:value-of select="SECURE[1]/CAUSE"/><xsl:text>|</xsl:text>
                    <xsl:text>&#13;&#10;</xsl:text>
                </xsl:if>
                <xsl:apply-templates select="UF"/>
                
        </xsl:template>
        
        <xsl:template match="UF">
                <xsl:text>UF||</xsl:text>
                <xsl:value-of select="NOM_UK"/><xsl:text>|</xsl:text><!--NOM_UF-->
                <xsl:value-of select="DATE_UK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:if test="NUBP/BUDG_LEVEL=1"><xsl:value-of select="NUBP/KOD_UBP"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/LS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_GRS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="GLAVA_GRS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/NAME_BUDG"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/NAME_UBP_FO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/OKPO_FO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/LS_FO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/NAME_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUBP/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="FUND_SOURCE"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NOM_ZF"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_ZF"/><xsl:text>|</xsl:text>
                <xsl:value-of select="CNAME_PL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="INN_PL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KPP_PL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PASP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="BS_PL"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DOL_RUK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_RUK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DOL_ISP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_ISP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TEL_ISP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_POD"/><xsl:text>|</xsl:text>
                <xsl:text>|</xsl:text><!--DOL_RUK_TOFK-->
                <xsl:text>|</xsl:text><!--NAME_RUK_TOFK-->
                <xsl:text>|</xsl:text><!--DOL_ISP_TOFK-->
                <xsl:text>|</xsl:text><!--NAME_ISP_TOFK-->
                <xsl:text>|</xsl:text><!--TEL_ISP_TOFK-->
                <xsl:text>|</xsl:text><!--DATE_TOFK-->
                <xsl:text>&#13;&#10;</xsl:text>
        
                <xsl:apply-templates select="UKPP"/>
                <xsl:apply-templates select="UKPP_N"/>
        </xsl:template>
        <xsl:template match="UKPP">
                <xsl:text>UFPP|</xsl:text>
                <xsl:value-of select="LINE_NOM"/><xsl:text>|</xsl:text>
                <xsl:value-of select="GUID"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KOD_DOC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAME_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NOM_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="CNAME_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="INN_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KPP_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="OKATO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KBK"/><xsl:text>|</xsl:text>
                <xsl:choose>
                        <xsl:when test="TYPE_KBK=''">10</xsl:when>
                        <xsl:when test="TYPE_KBK=''">20</xsl:when>
                        <xsl:when test="TYPE_KBK=''">31</xsl:when>
                        <xsl:when test="TYPE_KBK=''">32</xsl:when>
                        <xsl:otherwise></xsl:otherwise>
                </xsl:choose><xsl:text>|</xsl:text>
                <xsl:value-of select="ADD_KLASS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="SUM_PP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PURPOSE"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NOM_ZR"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_ZR"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NOTE"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
        
        </xsl:template>
        <xsl:template match="UKPP_N">
                <xsl:text>UFPP_N|</xsl:text>
                <xsl:value-of select="LINE_NOM"/><xsl:text>|</xsl:text>
                <xsl:value-of select="CNAME_NUBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="INN_NUBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KPP_NUBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="OKATO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="LS_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KBK"/><xsl:text>|</xsl:text>
                <xsl:choose>
                        <xsl:when test="TYPE_KBK=''">10</xsl:when>
                        <xsl:when test="TYPE_KBK=''">20</xsl:when>
                        <xsl:when test="TYPE_KBK=''">31</xsl:when>
                        <xsl:when test="TYPE_KBK=''">32</xsl:when>
                        <xsl:otherwise></xsl:otherwise>
                </xsl:choose><xsl:text>|</xsl:text>
                <xsl:value-of select="ADD_KLASS"/><xsl:text>|</xsl:text>
                <xsl:if test="not(SUM=0)"><xsl:value-of select="SUM"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:value-of select="PURPOSE"/><xsl:text>|</xsl:text>
                <xsl:value-of select="FUND_SOURCE"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
        
        </xsl:template>
</xsl:stylesheet>


