<?xml version="1.0" encoding="windows-1251"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
        <xsl:output method="xml" encoding="windows-1251" indent="yes"/>
        <xsl:strip-space elements="*"/>
        <xsl:variable name="accept"> !"#$%'()*+,-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{}~</xsl:variable>
        <xsl:template name="CheckSym">
                <xsl:param name="sym"/>
                <xsl:param name="count"/>
                <xsl:param name="name"/>
                <xsl:if test="not(contains($accept,substring($sym,$count,1)))">
                        <xsl:element name="error">
                                <xsl:attribute name="must">1</xsl:attribute>
                                <xsl:text/> "<xsl:value-of select="$name"/>"   "<xsl:value-of select="substring($sym,$count,1)"/>"   <xsl:value-of select="$count"/>
                        </xsl:element>
                </xsl:if>
                <xsl:if test="$count &lt; string-length($sym)">
                        <xsl:call-template name="CheckSym">
                                <xsl:with-param name="sym" select="$sym"/>
                                <xsl:with-param name="name" select="$name"/>
                                <xsl:with-param name="count" select="$count+1"/>
                        </xsl:call-template>
                </xsl:if>
        </xsl:template>
        <xsl:template name="CheckS">
                <xsl:param name="value"/>
                <xsl:param name="name"/>
                <xsl:param name="must"/>
                <xsl:param name="length"/>
                <xsl:variable name="labs">
                        <xsl:choose>
                                <xsl:when test="$length &gt; 0">
                                        <xsl:value-of select="$length"/>
                                </xsl:when>
                                <xsl:otherwise>
                                        <xsl:value-of select="-1*$length"/>
                                </xsl:otherwise>
                        </xsl:choose>
                </xsl:variable>
                <xsl:if test="string-length($value)=0 and not($must=-1) ">
                        <xsl:element name="error">
                                <xsl:attribute name="must">
                                        <xsl:value-of select="$must"/>
                                </xsl:attribute>
                                <xsl:choose>
                                        <xsl:when test="$must=1">  </xsl:when>
                                        <xsl:otherwise> </xsl:otherwise>
                                </xsl:choose>
                                <xsl:text/>"<xsl:value-of select="$name"/>"  .</xsl:element>
                </xsl:if>
                <xsl:if test="string-length($value)&gt;0">
                        <xsl:call-template name="CheckSym">
                                <xsl:with-param name="sym" select="$value"/>
                                <xsl:with-param name="name" select="$name"/>
                                <xsl:with-param name="count" select="1"/>
                        </xsl:call-template>
                        <xsl:if test="string-length($value) &gt; $labs">
                                <xsl:element name="error">
                                        <xsl:attribute name="must">1</xsl:attribute>
                                        <xsl:text/> "<xsl:value-of select="$name"/>"    (<xsl:value-of select="$labs"/>)</xsl:element>
                        </xsl:if>
                        <xsl:if test="(string-length($value) &lt; $length) and ($length &gt; 0)">
                                <xsl:element name="error">
                                        <xsl:attribute name="must">1</xsl:attribute>
                                        <xsl:text/> "<xsl:value-of select="$name"/>"    (<xsl:value-of select="$length"/>)</xsl:element>
                        </xsl:if>
                </xsl:if>
        </xsl:template>
        <xsl:template name="validate" match="TS">
                <xsl:element name="errors">
                        <xsl:if test="UCH_TB=0">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute> ''  </xsl:element>
                        </xsl:if>
                        <xsl:if test="not (KLIENT/BUDG_LEVEL=6)">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>    : 6 -  ˻.</xsl:element>
                        </xsl:if>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">1</xsl:with-param>
                                <xsl:with-param name="value" select="TYPE"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-8</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/KOD_UBP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">11</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/LS"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/NAME_UBP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">4</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/KOD_TOFK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/NAME_TOFK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">8</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/OKPO_TOFK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">4</xsl:with-param>
                                <xsl:with-param name="value" select="GOD_SUBS"/>
                        </xsl:call-template>
                        <xsl:if test="DATE_SUBS=''">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>   </xsl:element>
                        </xsl:if>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">   </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">8</xsl:with-param><!-- -10  -->
                                <xsl:with-param name="value" select="KLIENT/OKPO"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">10</xsl:with-param><!-- -12  -->
                                <xsl:with-param name="value" select="KLIENT/INN"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param><!-- -1  -->
                                <xsl:with-param name="length">9</xsl:with-param>
                                <xsl:with-param name="value" select="KLIENT/KPP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param><!--  /  ,    -->
                                <xsl:with-param name="length">-512</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_BUD"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"></xsl:with-param>
                                <xsl:with-param name="must">0</xsl:with-param>
                                <xsl:with-param name="length">8</xsl:with-param>
                                <xsl:with-param name="value" select="OKATO"/><!--OKTMO-->
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_UCHR"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">3</xsl:with-param>
                                <xsl:with-param name="value" select="GLAVA_UCHR"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                                <xsl:with-param name="must">-1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_RUK"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name">  - </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="NAME_RUK_FES"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-100</xsl:with-param>
                                <xsl:with-param name="value" select="DOL_ISP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="FIO_ISP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">-1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="TEL_ISP"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-2000</xsl:with-param>
                                <xsl:with-param name="value" select="ORG_SIG"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> ,  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-100</xsl:with-param>
                                <xsl:with-param name="value" select="DOL_SIG"/>
                        </xsl:call-template>
                        <xsl:call-template name="CheckS"><xsl:with-param name="name"> ,  </xsl:with-param>
                                <xsl:with-param name="must">1</xsl:with-param>
                                <xsl:with-param name="length">-50</xsl:with-param>
                                <xsl:with-param name="value" select="FIO_SIG"/>
                        </xsl:call-template>
                        <xsl:if test="DATE_SIG=''">
                                <xsl:element name="error"><xsl:attribute name="must">1</xsl:attribute>    </xsl:element>
                        </xsl:if>
                        <xsl:apply-templates select="TSSUBS"/>
                </xsl:element>
        </xsl:template>
        <xsl:template match="TSSUBS">
                <xsl:call-template name="CheckS"><xsl:with-param name="name">  </xsl:with-param>
                        <xsl:with-param name="must">1</xsl:with-param>
                        <xsl:with-param name="length">-2000</xsl:with-param>
                        <xsl:with-param name="value" select="NAME_SUBS"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">  </xsl:with-param>
                        <xsl:with-param name="must"><xsl:choose>
                                <xsl:when test="not (sum_in=0) or not (sum_out=0) ">1</xsl:when>
                                <xsl:otherwise>-1</xsl:otherwise>
                        </xsl:choose></xsl:with-param>
<!--      SUM_PLAN_POST  SUM_PLAN_VIP, .-->
                        <xsl:with-param name="length">-20</xsl:with-param>
                        <xsl:with-param name="value" select="CODE_SUBS"/>
                </xsl:call-template>
                <xsl:variable name="pre_year">  <xsl:choose>
                        <xsl:when test="summ_pre=0">0</xsl:when>
                        <xsl:otherwise>1</xsl:otherwise>
                </xsl:choose></xsl:variable>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name"> </xsl:with-param>
			<xsl:with-param name="must">-1</xsl:with-param>
<!--      SUM_PERMIT_OST  .    .-->
                        <xsl:with-param name="length">3</xsl:with-param>
                        <xsl:with-param name="value" select="KBK_R"/>
                </xsl:call-template>
                <xsl:call-template name="CheckS">
                        <xsl:with-param name="name">    </xsl:with-param>
			<xsl:with-param name="must">-1</xsl:with-param>
<!--      SUM_PERMIT_OST  .-->
                        <xsl:with-param name="length">-20</xsl:with-param>
                        <xsl:with-param name="value" select="ADD_KLASS"/>
                </xsl:call-template>
        
        </xsl:template>
</xsl:stylesheet>
