<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
        <xsl:output method="text"  encoding="windows-1251"/>
        <xsl:strip-space elements="*"/>

        <xsl:template match="pack">
                <!-- -->
                <xsl:text>FK|2016.01|</xsl:text><xsl:value-of select="@FORMER"/><xsl:text>|</xsl:text>
                <xsl:value-of select="substring(@FORM_VER,1,10)"/><xsl:text>||&#13;&#10;</xsl:text>
                <!-- -->
                <xsl:text>FROM|</xsl:text>
                <xsl:choose>
                    <xsl:when test="string-length(PP[1]/PAY/KOD_UBP) = 8">
                        <xsl:value-of select="substring(PP[1]/PAY/KOD_UBP,4,5)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="PP[1]/PAY/KOD_UBP"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>|</xsl:text>
                <xsl:value-of select="PP[1]/PAY/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:text>|</xsl:text>
                <xsl:text>|&#13;&#10;</xsl:text>

                <!-- -->
                <xsl:text>TO|</xsl:text>
                <xsl:text>|</xsl:text>
                <xsl:text>|</xsl:text>
                <xsl:value-of select="PP[1]/PAY/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PP[1]/PAY/NAME_TOFK"/><xsl:text>|&#13;&#10;</xsl:text>
                <!---->
                <xsl:apply-templates select="PP"/>
        </xsl:template>
        
        <xsl:template match="PP">
                <xsl:text>PP|</xsl:text>
                <xsl:value-of select="NOM"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE"/><xsl:text>|</xsl:text>
                <xsl:choose>
                        <xsl:when test="VID_PL = '' ">4</xsl:when>
                        <xsl:when test="VID_PL = '4' ">4</xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose><xsl:text>|</xsl:text>
                <xsl:value-of select="SUM*100"/><xsl:text>|</xsl:text>
                <!--       ,     -->
                <!--<xsl:value-of select="SUM*100"/><xsl:text>|</xsl:text>-->
                <xsl:value-of select="PAY/INN"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/KPP"/><xsl:text>|</xsl:text>
                <xsl:choose>
                    <xsl:when test="string-length(PAY/KOD_UBP) = 8">
                        <xsl:value-of select="substring(PAY/KOD_UBP,4,5)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="PAY/KOD_UBP"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/NAME_UBP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/CNAME"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/LS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/KOD_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/INN_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/NAME_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/BS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/BIC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/NAME_BIC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/FILIAL_BIC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAY/BS_KS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/INN"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/KPP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/CNAME"/><xsl:text>|</xsl:text>
                <xsl:if test="not (RCP/NAME_TOFK = '')"><xsl:value-of select="RCP/INN_TOFK"/></xsl:if><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/NAME_TOFK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/BS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/LS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/BIC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/NAME_BIC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/FILIAL_BIC"/><xsl:text>|</xsl:text>
                <xsl:value-of select="RCP/BS_KS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_PAY"/><xsl:text>|</xsl:text>
                <xsl:value-of select="ORDER_PAY"/><xsl:text>|</xsl:text>
                <xsl:value-of select="UIN"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PURPOSE"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PRINT_KPP"/><xsl:text>|</xsl:text>
                <xsl:value-of select="PAYSTATUS"/><xsl:text>|</xsl:text>
                <xsl:value-of select="KBK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="OKATO"/><xsl:text>|</xsl:text>
                <xsl:value-of select="OSNPLAT"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NAL_PER"/><xsl:text>|</xsl:text>
                <xsl:value-of select="NUM_DOK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="DATE_DOK"/><xsl:text>|</xsl:text>
                <xsl:value-of select="TYPE_PL"/><xsl:text>|</xsl:text>
                <xsl:text>&#13;&#10;</xsl:text>
                <xsl:apply-templates select="PPST"/>
        </xsl:template>
        <xsl:template match="PPST">
            <xsl:text>PPST|</xsl:text>
            <xsl:choose>
            <xsl:when test="TYPE_KBK=''">
                <xsl:value-of select="substring(KBK,1,3)"/><xsl:text>|</xsl:text><!-- -->
                <xsl:value-of select="substring(KBK,4,4)"/><xsl:text>|</xsl:text><!-- -->
                <xsl:value-of select="substring(KBK,8,3)"/><xsl:text>|</xsl:text><!--  -->
                <xsl:value-of select="substring(KBK,11,3)"/><xsl:text>|</xsl:text><!--  -->
                <xsl:value-of select="CODECP"/><xsl:text>|</xsl:text><!--  -->
                <xsl:value-of select="substring(KBK,15,6)"/><xsl:text>|</xsl:text><!-- -->
                <xsl:text>|||</xsl:text>
                <!--  -->
            </xsl:when>
            <xsl:when test="TYPE_KBK=''">
                <xsl:text>||||||</xsl:text>
                <xsl:value-of select="KBK"/>
                <xsl:text>|||</xsl:text>
            </xsl:when>
            <xsl:when test="TYPE_KBK=''">
                <xsl:text>|||||||</xsl:text>
                <xsl:value-of select="KBK"/>
                <xsl:text>||</xsl:text>
            </xsl:when>
            <xsl:when test="TYPE_KBK=''">
                <xsl:text>||||||||</xsl:text>
                <xsl:value-of select="KBK"/>
                <xsl:text>|</xsl:text>
            </xsl:when>
            </xsl:choose>
            <xsl:value-of select="NUM_BO"/><xsl:text>|</xsl:text>
            <xsl:value-of select="MES_FIN"/><xsl:text>|</xsl:text>
            <xsl:value-of select="SUM*100"/><xsl:text>|</xsl:text>
            <!--       ,     -->
            <!--<xsl:value-of select="SUM*100"/><xsl:text>|</xsl:text>-->
            <xsl:value-of select="REZERV"/><xsl:text>|&#13;&#10;</xsl:text>
        </xsl:template>
</xsl:stylesheet>