"""Python.Interpreter COM Server

  This module implements a very very simple COM server which
  exposes the Python interpreter.

  This is designed more as a demonstration than a full blown COM server.
  General functionality and Error handling are both limited.
"""

from win32com.server.exception import Exception
import winerror

# Expose the Python interpreter.
class Interpreter:
    """The interpreter object exposed via COM
    """
    _public_methods_ = [ 'Exec', 'Eval' ]
    # All registration stuff to support fully automatic register/unregister
    _reg_verprogid_ = "TBB_Py.Interpreter.2"
    _reg_progid_ = "TBB_Py.Interpreter"
    _reg_desc_ = "Python Interpreter portable OLE, especially for using with TB.Budget software"
    _reg_clsid_ = "{30BD3490-2632-11cf-AD5B-524153487881}"
    _reg_class_spec_ = "TB69extTBB.Interpreter"

    def __init__(self):
        self.dict = {}

    def Eval(self, exp):
        """Evaluate an expression.
        """
        if type(exp) not in [str, unicode]:
            raise Exception(desc="Must be a string",scode=winerror.DISP_E_TYPEMISMATCH)
        exp=exp.encode("cp1251")
        return eval(str(exp), self.dict)
    def Exec(self, exp):
        """Execute a statement.
        """
        exp=exp.encode("cp1251")
        if type(exp) not in [str, unicode]:
            raise Exception(desc="Must be a string",scode=winerror.DISP_E_TYPEMISMATCH)
        exec str(exp) in self.dict

def Register():
    import win32com.server.register
    return win32com.server.register.UseCommandLine(Interpreter)

if __name__=='__main__':
    print "Registering COM server..."
    Register()
